///////////////////////////////////////////////////////////////////////////////////
//No part of this file can be copied or released without the consent of 
//Avalanche Technology
//										
///////////////////////////////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////////////////////////////
//										
//	Avalanche Technology Inc., Proprietary and Confidential	   *
//										
// 	Release:  3.0    Date 5/25/2023  	
//							
//////////////////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////////////
//  PART DESCRIPTION:
//
//  Technology: 22nm pMTJ STT-MRAM
//  Part:       AS301GB32/AS304GB32
//
//  Description: 1 Gigabit/4 Gigabit  PARALLEL PERSISTENT SRAM MEMORY
//
////////////////////////////////////////////////////////////////////////////////////
//  FILE CONTENTS : Sample Stimulus for Testbench
//
////////////////////////////////////////////////////////////////////////////////////


////////////////////////////////////////////////////////////////////////////////////
// MODULE DECLARATION                                                             //
////////////////////////////////////////////////////////////////////////////////////

`timescale 1ns/1ps

module stimulus (
	output reg En,
	output reg Wn,
	output reg PGn,
	output reg CRn,

	output reg [24:0] ADDR,
	inout [31:0] DQ,
 	output reg Gn
	);

reg [31:0] DQ_reg;
reg out_en;
reg CE_WRITE;
reg CE_READ;
reg ADR_READ;

`include "./task.v"

assign DQ = out_en ? DQ_reg : 32'hz;

initial begin
  En = 1'b1;
  Wn = 1'b1;
  Gn = 1'b1;
  PGn = 1'b1;
  CRn = 1'b1;
  ADDR = 0;
  DQ_reg = 0;
  out_en = 0;
  CE_WRITE = 1;
  CE_READ = 1;
  ADR_READ = 1;
end

initial begin
    #100;

    $display("==== [TEST] Write Read Sequence ====");
    //WriteReadCheck();
    //WriteRelTime(25'h100, 32'h00010001, 8'd0,8'd5,8'd10,8'd15,8'd0,8'd15);
    //WriteRelTime(25'h200, 32'h00020002, 8'd0,8'd5,8'd10,8'd15,8'd0,8'd15);
    //WriteRelTime(25'h300, 32'h00030003, 8'd0,8'd0,8'd13,8'd15,8'd0,8'd17);
    //ReadRelTime(25'h100,32'h00010001, 8'd0,8'd20,8'd26,8'd0,8'd0);
    //ReadRelTime(25'h200,32'h00020002, 8'd0,8'd20,8'd26,8'd0,8'd0);
    //ReadRelTime(25'h300,32'h00030003, 8'd0,8'd20,8'd26,8'd0,8'd0);
    Write(25'h100, 32'h00010001);
    Write(25'h200, 32'h00020002);
    Write(25'h300, 32'h00030003);
    Read(25'h100,32'h00010001);
    Read(25'h200,32'h00020002);
    Read(25'h300,32'h00030003);

    $display("==== [TEST] Config register write/read ====");
    ConfigEnter();
    Write(25'h11, 32'habcd1234);
    Write(25'h12, 32'h12345678);
    Write(25'h40, 32'h1234abcd);
    Write(25'h00, 32'haaaa5555);
    //ReadRelTime(21'h40,32'h1234abcd, 8'd0,8'd20,8'd26,8'd0,8'd0);
    //ReadRelTime(21'h10,32'habcd1234, 8'd0,8'd20,8'd26,8'd0,8'd0);
    //ReadRelTime(21'h00,32'h00000000, 8'd0,8'd20,8'd26,8'd0,8'd0);
    //ReadRelTime(21'h12,32'h12345678, 8'd0,8'd20,8'd26,8'd0,8'd0);
    Read(21'h40,32'h05);
    Read(21'h11,32'habcd1234);
    Read(21'h00,32'h00000000);
    Read(21'h12,32'h12345678);
    ConfigExit();

    SelectChip();
    Write(25'h10, 32'habcd1234);
    Write(25'h12, 32'h12345678);
    Write(25'h40, 32'h1234abcd);
    DeSelChip();
    #100;

    $display("==== [TEST] ECC Engine ====");
    ConfigEnter();
    Write(25'h10, 32'h1); // ECC Test Enable
    Write(25'h11, 32'ha5a55a5a); // ECC Error Inject
    Write(25'h12, 32'hdeadbeef); // ECC Data in
    Write(25'h0, 32'h55aa55aa); // Dummy write
    //ReadRelTime(25'h13,32'h7b08e4b5, 8'd0,8'd20,8'd26,8'd0,8'd0); // ECC Data Out
    //ReadRelTime(25'h21,32'd16, 8'd0,8'd20,8'd26,8'd0,8'd0); // ECC Error Count 
    //ReadRelTime(25'h22,32'h1, 8'd0,8'd20,8'd26,8'd0,8'd0); // ECC Interrupt Flag 
    Read(25'h13,32'h7b08e4b5); // ECC Data Out
    Read(25'h21,32'd16); // ECC Error Count 
    Read(25'h22,32'h1); // ECC Interrupt Flag 

    En=0;
    Write(25'h20, 32'h3); // ECC Control Register: Clear flag and error count

    //ReadRelTime(25'h21,32'd16, 8'd0,8'd20,8'd26,8'd0,8'd0); // ECC Error Count 
    //ReadRelTime(25'h22,32'h1, 8'd0,8'd20,8'd26,8'd0,8'd0); // ECC Interrupt Flag 
    //ReadRelTime(25'h20,32'h3, 8'd0,8'd20,8'd26,8'd0,8'd0); // ECC Control Register
    Read(25'h21,32'h0); // ECC Error Count 
    Read(25'h22,32'h0); // ECC Interrupt Flag 
    Read(25'h20,32'h0); // ECC Control Register
    ConfigExit();
    #100;

    Write(25'h30, 32'habcd1234);
    Read(25'h30, 32'habcd1234);
    #100;

    $display("==== [TEST] Page mode write ====");
    PGWriteSeq({25'h1234, 2'd0}, 32'h10101000, 7);
    Read({25'h1234, 2'd0},32'h10101000);
    Read({25'h1234, 2'd1},32'h10101007);
    Read({25'h1234, 2'd2},32'h1010100E);
    Read({25'h1234, 2'd3},32'h10101015);
    #100;

    $display("==== [TEST] Page mode read ====");
    Write(25'hAC0000, 32'habcd);
    Write(25'hAC0001, 32'habd9);
    Write(25'hAC0002, 32'habe5);
    Write(25'hAC0003, 32'habf1);
    Write(25'hAC0004, 32'habfd);
    Write(25'hAC0005, 32'hac09);
    Write(25'hAC0006, 32'hac15);
    Write(25'hAC0007, 32'hac21);
    Write(25'hAC0008, 32'hac2d);
    Write(25'hAC0009, 32'hac39);
    Write(25'hAC000A, 32'hac45);
    Write(25'hAC000B, 32'hac51);
    Write(25'hAC000C, 32'hac5d);
    PGReadSeq(25'hAC0000, 32'habcd, 12, 12, 0);

    #100;
    PGReadSeq(25'hAC0000, 32'habcd, 12, 12, 1);

    #100;
    $finish();
end

endmodule
